/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1993  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/

/*

LIBRARY        : alteralib; Rev 1.0; February 93
FUNCTION       : DUAL 2-LINE TO 4-LINE DECODERS/MULTIPLEXERS WITH OPEN COLLECTOR OUTPUTS
TRUTHTABLE     : 
    -------------------------------------------------
                 2-LINE 4-LINE DECODER
      B   A   G1_ C1  1Y0..1Y3    2G_ 2C_  2Y0..2Y3
    -------------------------------------------------
      X   X   H   X     HHHH      H   X     HHHH
      L   L   L   H     LHHH      L   L     LHHH
      L   H   L   H     HLHH      L   L     HLHH
      H   L   L   H     HHLH      L   L     HHLH
      H   H   L   H     HHHL      L   L     HHHL
      X   X   X   L     HHHH      X   H     HHHH
    ------------------------------------------------- 
          ------------------------------------
                 3-LINE 8-LINE DECODER
            C+ B   A   G+  2Y0..2Y3 1Y0..1Y3
          ------------------------------------
            X  X   X   H      HHHH   HHHH          
            L  L   L   L      LHHH   HHHH          
            L  L   H   L      HLHH   HHHH
            L  H   L   L      HHLH   HHHH     
            L  H   H   L      HHHL   HHHH     
            H  L   L   L      HHHH   LHHH
            H  L   H   L      HHHH   HLHH
            H  H   L   L      HHHH   HHLH
            H  H   H   L      HHHH   HHHL
          ------------------------------------

   NOTE: C+ = C1 & C2_  CONNECTED TOGETHER 
         G+ = G1_ & G2_  CONNECTED TOGETHER
       
REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a156 (c1, gn1, b, y13, y12, y11, y10, y20, y21, y22, y23, a, gn2, cn2);
	parameter size =1;
	input
		c1,
		gn1,
		b,
		a,
		gn2,
		cn2;
	output
		y13,
		y12,
		y11,
		y10,
		y20,
		y21,
		y22,
		y23;
    tri1
        _1Y0, _1Y1, _1Y2, _1Y3,
        _2Y0, _2Y1, _2Y2, _2Y3;
    nor
	M156_inst_N1 (m156_inst_g1, gn1, m156_inst_c1b);
    nor
	M156_inst_N2 (m156_inst_g2, gn2, cn2);
    not  
	M156_inst_N3 (m156_inst_na, a);
    not  
	M156_inst_N4 (m156_inst_nb, b);
    not  
	M156_inst_N5 (m156_inst_c1b, c1);
    nand (strong0 , highz1)   
	M156_inst_ND0 (y10, m156_inst_g1, m156_inst_na, m156_inst_nb);
    nand (strong0 , highz1)   
	M156_inst_ND1 (y11, m156_inst_g1, dd_net_14, m156_inst_nb);
    nand (strong0 , highz1)   
	M156_inst_ND2 (y12, m156_inst_g1, m156_inst_na, dd_net_18);
    nand (strong0 , highz1)   
	M156_inst_ND3 (y13, m156_inst_g1, dd_net_14, dd_net_18);
    nand (strong0 , highz1)   
	M156_inst_ND4 (y20, m156_inst_g2, m156_inst_na, m156_inst_nb);
    nand (strong0 , highz1)   
	M156_inst_ND5 (y21, m156_inst_g2, dd_net_14, m156_inst_nb);
    nand (strong0 , highz1)   
	M156_inst_ND6 (y22, m156_inst_g2, m156_inst_na, dd_net_18);
    nand (strong0 , highz1)   
	M156_inst_ND7 (y23, m156_inst_g2, dd_net_14, dd_net_18);
    buf  
	  (dd_net_14, a);
    buf  
	  (dd_net_18, b);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
